// LAB:10 : Design the following IIR filters with the given specification.
//           (1) Butter Worth  (2) Chebyshev-I  (3) Chebyshev-II  (4) Elliptical 

////////////////////////////////////////////////////////////////////////
//    Example:
//                 filter type ('lp','hp','sb','bp')
//                 design approximation ('butt','cheb1','cheb2','ellip')
//                 om=[om1,om2,om3,om4], 0 <= om1 <= om2 <= om3 <= om4 <= pi .When ftype='lp' or 'hp', om3 and om4 are not used and may be set to 0.
//                 0<= deltap <=1
//                 0<= deltas <=1
///////////////////////////////////////////////////////////////////////////

//Evaluate magnitude response of the filter

// Version : Scilab 5.4.1
// Operating System : Window-xp, Window-7

clc;
close;
clear;

ftype='bp'; // Type of Filter
approx='ellip'; //Design Approximation
om=[.15 .25]; // Cut off Frequency
deltap=0.08; 
deltas=0.03;

hz_ellip=iir(3,ftype,approx,om,[deltap deltas]); // Band Pass Filter with Elliptic
[hzm1,fr1]=frmag(hz_ellip,256); //Frequency Magnitude
hz_butt=iir(3,ftype,'butt',om,[deltap deltas]); // Band Pass Filter with Butterworth
[hzm2,fr2]=frmag(hz_butt,256); //Frequency Magnitude
hz_cheby1=iir(3,ftype,'cheb1',om,[deltap deltas]); // Band Pass Filter with Chebysev 1
[hzm3,fr3]=frmag(hz_cheby1,256); //Frequency Magnitude
hz_cheby2=iir(3,ftype,'cheb2',om,[deltap deltas]); // Band Pass Filter with Chebysev 1
[hzm4,fr4]=frmag(hz_cheby2,256); //Frequency Magnitude

plot(fr1',hzm1',fr2',hzm2',fr3',hzm3',fr4',hzm4');
xtitle('Discrete IIR filter band pass  0.15 < fr < 0.25 ',' ',' ');
xlabel('Frequency Scale');
ylabel('Magnitude');
h=legend(['Ellip';'Butter';'Chaby1';'Cheby2']);

